### **1. Objectives of Post-Exploitation**

- After gaining access to a system, attackers aim to:
    - Gather **system and network information**.
    - Identify **user privileges** and running processes.
    - Locate **connected systems** for lateral movement.
    - Establish **persistence** on the compromised machine.

---

### **2. Tools and Techniques Used in Post-Exploitation**

#### **a) Built-in Operating System Commands**

Attackers often use legitimate administrative tools to avoid detection. Common commands include:

- **`whoami`**: Displays the current user account and domain information.
- **`ipconfig`**: Shows network configuration, including gateway, DHCP, and DNS server information.
- **`netstat –anop`**: Lists active, listening, and closed network connections.
- **`quser`**: Lists logged-on users.
- **`tasklist`**: Lists all running processes.
- **`schtasks`**: Displays tasks set to run at scheduled intervals.
- **`sc`**: Lists services set to run on the system.
- **`net start`**: Starts services on the system.

#### **b) Network Discovery**

- Attackers identify other connected systems for lateral movement by:
    - Performing **ping sweeps**.
    - Running **port scans**.

---

### **3. PowerShell in Post-Exploitation**

#### **What is PowerShell?**

- A task automation and configuration management framework from Microsoft.
- Commonly used by IT administrators and attackers due to its versatility and power.

#### **PowerShell Features Useful to Attackers**

- **Download Files**: Retrieve files from the internet or other systems.
- **Move Files**: Transfer files between systems.
- **Network Listeners**: Set up tunneling for communication.
- **Extract Data**: Retrieve event log data from remote machines.

#### **Why Attackers Use PowerShell**

- **Stealth**:
    - Runs entirely from memory (no need to write files to disk).
    - Can execute on remote machines if credentials are known.
    - Scripts can be obfuscated (e.g., encoded with Base64) to evade detection.
- **Bypassing Security**:
    - Policies that prevent running unsigned scripts can be bypassed using commands like `-ExecutionPolicy Bypass`.
    - Piping commands together can also bypass restrictions.
- **Low Traceability**:
    - Unless PowerShell command auditing is enabled, actions leave no trace on the system.

---

### **4. Metasploit Framework and Post-Exploitation Tools**

#### **What is Metasploit?**

- A popular penetration testing tool with a wide range of post-exploitation capabilities.

#### **Meterpreter**

- **Description**:
    - An advanced multi-function attack payload included in Metasploit.
    - Resides entirely in memory, making it difficult to detect with traditional forensic tools.
- **Capabilities**:
    - Provides an interactive shell to explore target machines.
    - Executes code directly on the compromised host.

#### **Mimikatz**

- **What is Mimikatz?**
    - A post-exploitation tool written by Benjamin Delpy, integrated into Metasploit.
- **Purpose**:
    - Extracts credential data from Windows systems.
- **Capabilities**:
    - Retrieves plaintext passwords, hashes, PIN codes, and Kerberos tickets from memory.
    - Can run as a standalone executable or as a PowerShell module.
- **Example Usage**:
    - Using the Mimikatz module inside Meterpreter to extract password hashes from a compromised machine.

---

### **5. Defensive Measures Against Post-Exploitation**

- **Enable PowerShell Auditing**: Logs PowerShell commands for investigation.
- **Restrict Script Execution**: Enforce policies to block unauthorized or unsigned scripts.
- **Monitor Administrative Commands**: Watch for suspicious use of tools like `netstat`, `tasklist`, and `ipconfig`.
- **Detect Lateral Movement**: Monitor for unusual ping sweeps or port scans.
- **Use Endpoint Protection**: Implement advanced tools to detect in-memory attacks like Meterpreter and Mimikatz.